% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genOrdCat.R
\name{genOrdCat}
\alias{genOrdCat}
\title{Generate ordinal categorical data}
\usage{
genOrdCat(dtName, adjVar, baseprobs, catVar = "cat", asFactor = TRUE)
}
\arguments{
\item{dtName}{Name of complete data set}

\item{adjVar}{Adjustment variable  name in dtName - determines
logistic shift. This is specified assuming a cumulative logit
link.}

\item{baseprobs}{Baseline probability expressed as a vector of
probabilities. The values must sum to <= 1. If sum(baseprobs) < 1,
an additional category is added with probability 1 - sum(baseprobs).}

\item{catVar}{Name of the new categorical field. Defaults to "cat"}

\item{asFactor}{If asFactor == TRUE (default), new field is returned
as a factor. If asFactor == FALSE, new field is returned as an integer.}
}
\value{
Original data.table with added categorical field
}
\description{
Ordinal categorical data is added to an existing data set.
}
\examples{
#### Set definitions

def1 <- defData(varname = "male", formula = 0.45, dist = "binary", id = "idG")
def1 <- defData(def1, varname = "z", formula = "1.2*male", dist = "nonrandom")

#### Generate data

set.seed(20)

dx <- genData(1000, def1)

probs<-c(0.40, 0.25, 0.15)
dx <- genOrdCat(dx, adjVar = "z", probs, catVar = "grp")

}
