% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testLibrary.R
\name{tests}
\alias{compare}
\alias{fcompare}
\alias{fixed}
\alias{random}
\alias{rcompare}
\alias{tests}
\title{Specify a statistical test to apply}
\usage{
fixed(xname, method = c("z", "t", "lr", "kr", "pb"))

compare(model, method = c("lr", "pb"))

fcompare(model, method = c("lr", "kr", "pb"))

rcompare(model, method = c("lr", "pb"))

random()
}
\arguments{
\item{xname}{an explanatory variable to test (character).}

\item{method}{the type of test to apply (see Details).}

\item{model}{a null model for comparison (formula).}
}
\value{
A function which takes a fitted model as an argument and returns a single p-value.
}
\description{
Specify a statistical test to apply
}
\details{
\describe{
\item{\code{fixed}:}{
    Test a single fixed effect, specified by \code{xname}.}
\item{\code{compare}:}{
    Compare the current model to a smaller one specified by the formula \code{model}.}
\item{\code{fcompare}, \code{rcompare}:}{
    Similar to \code{compare}, but only the fixed/random part of the formula needs to be supplied.}
\item{\code{random}:}{
    Test the significance of a single random effect.}
}
}
\section{Methods}{


The \code{method} argument can be used to specify one of the following tests. Note that \code{"z"}
is only applicable to models fitted in \code{\link[lme4]{glmer}} and \code{"kr"} will only work with models
fitted with \code{\link[lme4]{lmer}}.

\describe{
\item{\code{z}:}{
    Z-test for models fitted with \code{\link[lme4]{glmer}} (or \code{\link{glm}}),
    using the p-value from \code{\link[=summary.merMod]{summary}}.}
\item{\code{t}:}{T-test for models fitted with \code{\link{lm}}}
\item{\code{lr}:}{Likelihood ratio test, using \code{\link[=anova.merMod]{anova}}.}
\item{\code{kr}:}{
    Kenward-Roger test, using \code{\link[pbkrtest]{KRmodcomp}}.
    This only applies to models fitted with \code{\link[lme4]{lmer}}, and compares models with
    different fixed effect specifications but equivalent random effects.}
\item{\code{pb}:}{
    Parametric bootstrap test, using \code{\link[pbkrtest]{PBmodcomp}}.
    This test will be very accurate, but is also very computationally expensive.}
}

Tests using \code{random} for a single random effect call \code{\link[RLRsim]{exactRLRT}}.
}
\examples{
lm1 <- lmer(y ~ x + (x|g), data=simdata)
lm0 <- lmer(y ~ x + (1|g), data=simdata)
anova(lm1, lm0)
compare(. ~ x + (1|g))(lm1)
rcompare(~ (1|g))(lm1)
\dontrun{powerSim(fm1, compare(. ~ x + (1|g)))}

}

