% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imgocr.R
\name{imgocr}
\alias{imgocr}
\title{Mathematical formulas and character recognition}
\usage{
imgocr(img, mode = "latex_ocr")
}
\arguments{
\item{img}{An image file, supporting jpg, png, bmp format.}

\item{mode}{Set service model. The value can be `latex_ocr`, `latex_ocr_turbo`, or
`simpletex_ocr`. The default value is `latex_ocr`. The `latex_ocr` and `latex_ocr_turbo`
are used for formula identification. `latex_ocr` is better than `latex_ocr_turbo`, but
`latex_ocr_turbo` is faster. `simpletex_ocr` is suitable for general image recognition.}
}
\value{
Text or mathematical formulas for Markdown and LaTeX.
}
\description{
Mathematical formulas and character recognition.
}
\examples{
\dontrun{
  imgocr("path/to/test.jpg")
  imgocr("path/to/test.png", mode = "latex_ocr_turbo")
  imgocr("path/to/test.bmp", mode = "simpletex_ocr")
}

}
