% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_predictive.simmr_output.R
\name{posterior_predictive}
\alias{posterior_predictive}
\title{Plot the posterior predictive distribution for a simmr run}
\usage{
posterior_predictive(simmr_out, group = 1, prob = 0.5, plot_ppc = TRUE)
}
\arguments{
\item{simmr_out}{A run of the simmr model from \code{\link{simmr_mcmc}} or
\code{\link{simmr_ffvb}}.}

\item{group}{Which group to run it for (currently only numeric rather than group names)}

\item{prob}{The probability interval for the posterior predictives. The default is 0.5 (i.e. 50pc intervals)}

\item{plot_ppc}{Whether to create a bayesplot of the posterior predictive or not.}
}
\value{
plot of posterior predictives and simulated values
}
\description{
This function takes the output from \code{\link{simmr_mcmc}} or
\code{\link{simmr_ffvb}} and plots the posterior predictive distribution
to enable visualisation of model fit. The simulated posterior predicted
values are returned as part of the object and can be saved for external use
}
\examples{
\donttest{
data(geese_data_day1)
simmr_1 <- with(
  geese_data_day1,
  simmr_load(
    mixtures = mixtures,
    source_names = source_names,
    source_means = source_means,
    source_sds = source_sds,
    correction_means = correction_means,
    correction_sds = correction_sds,
    concentration_means = concentration_means
  )
)

# Plot
plot(simmr_1)

# Print
simmr_1

# MCMC run
simmr_1_out <- simmr_mcmc(simmr_1)

# Prior predictive
post_pred <- posterior_predictive(simmr_1_out)
}
}
