% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory.R
\name{join}
\alias{join}
\title{Join trajectories}
\usage{
join(...)
}
\arguments{
\item{...}{trajectory objects.}
}
\value{
A new trajectory object.
}
\description{
Concatenate any number of trajectories in the order specified.
}
\examples{
t1 <- create_trajectory() \%>\% seize("dummy", 1)
t2 <- create_trajectory() \%>\% timeout(1)
t3 <- create_trajectory() \%>\% release("dummy", 1)

join(t1, t2, t3)

create_trajectory() \%>\%
  join(t1) \%>\%
  timeout(1) \%>\%
  join(t3)
}
\seealso{
Other methods for dealing with trajectories:
\link{create_trajectory}, \link{get_head}, \link{get_tail},
\link{get_n_activities}, \link{seize}, \link{release}, 
\link{set_attribute}, \link{timeout}, \link{branch}, \link{rollback}, \link{leave}, 
\link{seize_selected}, \link{release_selected}, \link{select}.
}

