% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience_funcs.R
\name{at}
\alias{at}
\title{Arrivals at specific times}
\usage{
at(...)
}
\arguments{
\item{...}{a vector or multiple parameters of times at which to initiate an arrival.}
}
\value{
Returns a generator function.
}
\description{
Generator convenience function to generate arrivals at specific times.
}
\examples{
t0 <- create_trajectory("my trajectory") \%>\%
  ## add an intake activity
  seize("nurse", 1) \%>\%
  timeout(function() rnorm(1, 15)) \%>\%
  release("nurse", 1) \%>\%
  ## add a consultation activity
  seize("doctor", 1) \%>\%
  timeout(function() rnorm(1, 20)) \%>\%
  release("doctor", 1) \%>\%
  ## add a planning activity
  seize("administration", 1) \%>\%
  timeout(function() rnorm(1, 5)) \%>\%
  release("administration", 1)
  
env <- simmer("SuperDuperSim") \%>\%
  add_resource("nurse", 1) \%>\%
  add_resource("doctor", 2) \%>\%
  add_resource("administration", 1) \%>\%
  add_generator("patient", t0, at(0, c(1,10,30), 40, 43))
}
\seealso{
\link{add_generator}
}

