% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixef_sim.r
\name{sim_continuous2}
\alias{sim_continuous2}
\title{Simulate continuous variables}
\usage{
sim_continuous2(
  n,
  dist = "rnorm",
  var_level = 1,
  variance = NULL,
  ther_sim = FALSE,
  ther_val = NULL,
  ...
)
}
\arguments{
\item{n}{A list of sample sizes.}

\item{dist}{A distribution function. This argument takes a quoted
R distribution function (e.g. 'rnorm'). Default is 'rnorm'.}

\item{var_level}{The level the variable should be simulated at. This can either 
be 1, 2, or 3 specifying a level 1, level 2, or level 3 variable 
respectively.}

\item{variance}{The variance for random effect simulation.}

\item{ther_sim}{A TRUE/FALSE flag indicating whether the error simulation 
function should be simulated, that is should the mean and standard deviation
used for standardization be simulated.}

\item{ther_val}{A vector of 2 that should include the theoretical mean and 
standard deviation of the generating function.}

\item{...}{Additional parameters to pass to the dist_fun argument.}
}
\description{
Function that simulates continuous variables. Any distribution function in 
R is supported.
}
