% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_reg_func.r
\name{sim_reg_single}
\alias{sim_reg_single}
\title{Master function to simulate single level data.}
\usage{
sim_reg_single(fixed, fixed_param, cov_param, n, error_var, with_err_gen,
  arima = FALSE, data_str, cor_vars = NULL, fact_vars = list(NULL),
  lvl1_err_params = NULL, arima_mod = list(NULL), contrasts = NULL,
  homogeneity = TRUE, heterogeneity_var = NULL,
  knot_args = list(NULL), ...)
}
\arguments{
\item{fixed}{One sided formula for fixed effects in the simulation.
To suppress intercept add -1 to formula.}

\item{fixed_param}{Fixed effect parameter values (i.e. beta weights). 
Must be same length as fixed.}

\item{cov_param}{List of arguments to pass to the continuous generating 
function, must be the same order as the variables specified in fixed. 
This list does not include intercept, time, factors, or 
interactions. Required arguments include:
\itemize{
  \item dist_fun: This is a quoted R distribution function.
  \item var_type: This is the level of variable to generate. Must be 
    'single'.
    Must be same order as fixed formula above.
}
Optional arguments to the distribution functions are in a nested list,
 see the examples or vignettes for example code.}

\item{n}{Cluster sample size.}

\item{error_var}{Scalar of error variance.}

\item{with_err_gen}{Simulated within cluster error distribution. 
Must be a quoted 'r' distribution function.}

\item{arima}{TRUE/FALSE flag indicating whether residuals should 
be correlated. If TRUE, must specify a valid model to pass to 
arima.sim via the arima_mod argument. 
See \code{\link{arima.sim}} for examples.}

\item{data_str}{Type of data. Must be "single".}

\item{cor_vars}{A vector of correlations between variables.}

\item{fact_vars}{A nested list of factor, categorical, or ordinal variable 
   specification, each list must include:
\itemize{
     \item numlevels = Number of levels for ordinal or factor variables.
     \item var_type = Must be 'single'.
 }
 Optional arguments include:
 \itemize{
     \item replace
     \item prob
     \item value.labels
 }
  See also \code{\link{sample}} for use of these optional arguments.}

\item{lvl1_err_params}{Additional parameters passed as a list on to the 
level one error generating function}

\item{arima_mod}{A list indicating the ARIMA model to pass to arima.sim. 
See \code{\link{arima.sim}} for examples.}

\item{contrasts}{An optional list that specifies the contrasts to be used 
for factor variables (i.e. those variables with .f or .c). 
See \code{\link{contrasts}} for more detail.}

\item{homogeneity}{Either TRUE (default) indicating homogeneity of variance
assumption is assumed or FALSE to indicate desire to generate heterogeneity 
of variance.}

\item{heterogeneity_var}{Variable name as a character string to use for 
heterogeneity of variance simulation.}

\item{knot_args}{A nested list of named knot arguments. See \code{\link{sim_knot}} 
for more details. Arguments must include:
  \itemize{
    \item var
    \item knot_locations
  }}

\item{...}{Not currently used.}
}
\description{
Takes simulation parameters as inputs and returns simulated data.
}
\details{
Simulates data for the simple regression models.  Returns a data frame with 
ID variables, fixed effects, and many other variables useful to help when 
running simulation studies.
}
\examples{
#' # generating parameters for single level regression
fixed <- ~1 + act + diff + numCourse + act:numCourse
fixed_param <- c(2, 4, 1, 3.5, 2)
cov_param <- list(dist_fun = c('rnorm', 'rnorm', 'rnorm'), 
   var_type = c("single", "single", "single"),
   opts = list(list(mean = 0, sd = 4), 
   list(mean = 0, sd = 3),
   list(mean = 0, sd = 3)))
n <- 150
error_var <- 3
with_err_gen <- 'rnorm'
temp_single <- sim_reg(fixed = fixed, fixed_param = fixed_param, 
   cov_param = cov_param, 
   n = n, error_var = error_var, with_err_gen = with_err_gen, 
   data_str = "single")
   
}
\seealso{
\code{\link{sim_reg}} for a convenient wrapper for all data 
conditions.
}
