% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rand_eff_sim.r
\name{cross_class}
\alias{cross_class}
\title{Cross Classified Generation}
\usage{
cross_class(num_ids, samp_size, random_param)
}
\arguments{
\item{num_ids}{Number of cross classified ids to generate.}

\item{samp_size}{Sample size to generate, this is used to pass to the 
\code{\link{sample}} function.}

\item{random_param}{A list of data generating characteristics used to generate
 the cross classified random effect. This function needs to include:
 \itemize{
   \item random_var The variance of the cross classified random effect.
   \item rand_gen The random generating function used.
 }
 Optional elements are:
\itemize{
    \item ther: Theorectial mean and variance from rand_gen,
    \item ther_sim: Simulate mean/variance for standardization purposes,
    \item cor_vars: Correlation between random effects,
    \item ...: Additional parameters needed for rand_gen function.
}
See \code{\link{sim_rand_eff}} for additional parameters that can be passed.}
}
\description{
Input cross classified simulation parameters, output cross classified structure
as a function of the original id variables. This function currently only supports
a single (intercept) cross classified random effect.
}
