% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfa_load_companies.R
\name{sfa_load_companies}
\alias{sfa_load_companies}
\title{List Companies}
\usage{
sfa_load_companies(
  api_key = getOption("sfa_api_key"),
  cache_dir = getOption("sfa_cache_dir"),
  details = FALSE
)
}
\arguments{
\item{api_key}{\link{character} Your 'SimFin' API key. It's recommended to set
the API key globally using \link{sfa_set_api_key}.}

\item{cache_dir}{\link{character} Your cache directory. It's recommended to set
the cache directory globally using \link{sfa_set_cache_dir}.}

\item{details}{\code{logical(1)}: If \code{TRUE}, return a more detailed data.table with additional columns. Default: \code{FALSE}.}
}
\value{
\code{data.table::data.table()} containing basic company information.
}
\description{
Get a list of all companies in the SimFin database. See \url{https://simfin.readme.io/reference/list-1} and \url{https://simfin.readme.io/reference/general-1} for more information.
}
