% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simer.Data.R
\name{simer.Data.Kin}
\alias{simer.Data.Kin}
\title{simer.Data.EMMA: To construct EMMA kinship matrix}
\usage{
simer.Data.Kin(
  fileKin = TRUE,
  fileMVP = "simer",
  out = NULL,
  method = "EMMA",
  sep = "\\t",
  threads = 10,
  verbose = TRUE
)
}
\arguments{
\item{fileKin}{kinship that represents relationship among individuals, n * n matrix, n is sample size.}

\item{fileMVP}{prefix for mvp format files.}

\item{out}{prefix of output file name.}

\item{method}{only"EMMA" method for now.}

\item{sep}{seperator for Kinship file.}

\item{threads}{the number of cpu.}

\item{verbose}{whether to print detail.}
}
\value{
Output file:
<out>.kin.bin
<out>.kin.desc
}
\description{
constructing EMMA kinship matrix.
}
\details{
Build date: Apr 19, 2023
Last update: Apr 19, 2023
}
\examples{
\donttest{
# Get the prefix of genotype data
fileMVP <- system.file("extdata", "01bigmemory", "demo", package = "simer")

# Check map data
simer.Data.Kin(fileKin = TRUE, fileMVP = fileMVP, out = tempfile("outfile"))
}
}
\author{
Haohao Zhang and Dong Yin
}
