contrmat <- function(n, type = c("Dunnett", "Tukey"), 
                     base = 1) {

    if (length(n) < 2) stop("less than two groups")
    if (!is.numeric(n)) stop(sQuote("n"), " is not numeric")
    m <- NULL
    type <- match.arg(type)
    k <- length(n)
    if (base < 1 || base > k) stop("base is not between 1 and ", k)
    CM <- c()
    rnames <- c()
    if (!is.null(names(n)))
        varnames <- names(n)
    else 
        varnames <- 1:length(n)

    kindx <- 1:k

    switch(type,
           "Dunnett" = {
             for(i in kindx[-base])
               CM <- rbind(CM, as.numeric(kindx == i) - as.numeric( kindx == base))
             rnames <- paste(varnames[kindx[-base]], "-", varnames[base])
           },
           "Tukey" = {
             for (i in 1:(k-1)) {
               for(j in (i+1):k) {
                 CM  <- rbind(CM, as.numeric(kindx==j)-as.numeric(kindx==i))
                 rnames <- c(rnames, paste(varnames[j], "-", varnames[i]))
               }
             }
           })
    rownames(CM) <- rnames
    colnames(CM) <- varnames
    attr(CM, "type") <- type
    class(CM) <- c("contrMat", "matrix")
    CM
}
