% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_dis.R
\name{simple_dis}
\alias{simple_dis}
\alias{univariate.dis}
\alias{conditional.dis}
\title{Simple generation of new variables}
\usage{
univariate.dis(puf, data, additional, weights, value = "data",
  fNA = NA)

conditional.dis(puf, data, additional, conditional, weights,
  value = "data", fNA = NA)
}
\arguments{
\item{puf}{data for which one additional column specified by function argument \sQuote{additional} is simulated}

\item{data}{donor data}

\item{additional}{name of variable to be simulated}

\item{weights}{sampling weights from data}

\item{value}{if \dQuote{data} then the puf including the additional variable is returned, otherwise only
the simulated vector.}

\item{fNA}{only used with missing values if another code as NA should be used}

\item{conditional}{conditioning variable}
}
\description{
Fast simulation of new variables based on univariate distributions
}
\details{
Function uni.distribution: random draws from the weighted univariate distribution of
the original data

Function conditional.dis: random draws from the weighted conditional distribution
(conditioned on a factor variable)

This are simple functions to produce structural variables, variables that
should have the same categories as given ones. For more advanced methods see simCategorical()
}
\examples{
## we don't have original data, so let's use eusilc
data(eusilc13puf)
data(eusilcS)
v1 <- univariate.dis(eusilcS, eusilc13puf, additional = "db040",
weights = "rb050", value = "vector")
table(v1)
table(eusilc13puf$db040)
## we don't have original data, so let's use eusilc
##data(eusilc13puf)
##data(eusilcS)
##v1 <- conditional.dis(eusilcS, eusilc13puf, additional = "pb190",
##  conditional = "db040", weights = "rb050")
##table(v1) / sum(table(v1))
##table(eusilc13puf$pb190) / sum(table(eusilc13puf$pb190))
}
\seealso{
\code{\link{simCategorical}}
}
\author{
Lydia Spies, Matthias Templ
}
