% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generators.R
\name{vlogis}
\alias{vlogis}
\title{Variate Generation for Logistic Distribution}
\usage{
vlogis(
  n,
  location = 0,
  scale = 1,
  stream = NULL,
  antithetic = FALSE,
  asList = FALSE
)
}
\arguments{
\item{n}{number of observations}

\item{location}{Location parameter}

\item{scale}{Scale parameter (default 1)}

\item{stream}{if \code{NULL} (default), uses \code{\link[=runif]{stats::runif}}
to generate uniform variates to invert via 
\code{\link[=qlogis]{stats::qlogis}};
otherwise, an integer in 1:25 indicates the \code{\link{rstream}} stream
from which to generate uniform variates to invert via
\code{\link[=qlogis]{stats::qlogis}};}

\item{antithetic}{if \code{FALSE} (default), inverts \eqn{u} = uniform(0,1)
variate(s) generated via either \code{\link[=runif]{stats::runif}} or
\code{\link[=rstream.sample]{rstream::rstream.sample}}; otherwise, uses
\eqn{1 - u}}

\item{asList}{if \code{FALSE} (default), output only the generated
random variates; otherwise, return a list with components suitable for
visualizing inversion. See return for details}
}
\value{
If \code{asList} is FALSE (default), return a vector of random variates.

  Otherwise, return a list with components suitable for visualizing inversion,
  specifically:
    \item{u}{        A vector of generated U(0,1) variates }
    \item{x}{        A vector of logistic random variates }
    \item{quantile}{ Parameterized quantile function }
    \item{text}{     Parameterized title of distribution }
}
\description{
Variate Generation for Logistic Distribution
}
\details{
Generates random variates from the logistic distribution.

  Logistic variates are generated by inverting uniform(0,1) variates
  produced either by \code{\link[=runif]{stats::runif}} (if \code{stream} is
  \code{NULL}) or by \code{\link[=rstream.sample]{rstream::rstream.sample}}
  (if \code{stream} is not \code{NULL}).
  In either case, \code{\link[=qlogis]{stats::qlogis}} is used to
  invert the uniform(0,1) variate(s).
  In this way, using \code{vlogis} provides a monotone and synchronized
  binomial variate generator, although not particularly fast.

  The stream indicated must be an integer between 1 and 25 inclusive.

The logistic distribution with \code{location} \eqn{= \mu}{= μ} and
 \code{scale} \eqn{= \sigma}{= σ} has distribution function

 \deqn{F(x) = \frac{1}{1 + e^{-(x - \mu) / \sigma}}}{%
       F(x) = 1 / (1 + exp(-(x-μ)/σ))}

 and density

 \deqn{f(x) = \frac{1}{\sigma} \frac{e^{(x-\mu)/\sigma}}
                     {(1 + e^{(x-\mu)/\sigma})^2}}{%
      f(x) = 1/σ exp((x-μ)/σ) (1 + exp((x-μ)/σ))^-2}

 It is a long-tailed distribution with mean \eqn{\mu}{μ} and
 variance \eqn{\pi^2 / 3 \sigma^2}{π^2 /3 σ^2}.
}
\examples{
 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qlogis
 vlogis(3, location = 5, scale = 0.5)

 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qlogis
 vlogis(3, 5, 1.5, stream = 1)
 vlogis(3, 5, 1.5, stream = 2)

 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qlogis
 vlogis(1, 5, 1.5, stream = 1)
 vlogis(1, 5, 1.5, stream = 2)
 vlogis(1, 5, 1.5, stream = 1)
 vlogis(1, 5, 1.5, stream = 2)
 vlogis(1, 5, 1.5, stream = 1)
 vlogis(1, 5, 1.5, stream = 2)

 set.seed(8675309)
 variates <- vlogis(1000, 5, 1.5, stream = 1)
 set.seed(8675309)
 variates <- vlogis(1000, 5, 1.5, stream = 1, antithetic = TRUE)

}
\seealso{
\code{\link{rstream}}, \code{\link{set.seed}},
         \code{\link[=runif]{stats::runif}}

\code{\link[=rlogis]{stats::rlogis}}
}
\author{
Barry Lawson (\email{blawson@richmond.edu}), \cr
   Larry Leemis (\email{leemis@math.wm.edu}), \cr
   Vadim Kudlay (\email{vadim.kudlay@richmond.edu})
}
\concept{random variate generation}
\keyword{distribution}
