% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_pedigree_genotypes.R
\name{sample_pedigree_genotypes}
\alias{sample_pedigree_genotypes}
\title{Sample genotypes for pedigree according to allele frequencies by allele dropping.}
\usage{
sample_pedigree_genotypes(pedigree, freqs, loci = names(freqs))
}
\arguments{
\item{pedigree}{\link[pedtools:ped]{ped} object}

\item{freqs}{Allele frequencies (see \link{read_allele_freqs})}

\item{loci}{Character vector of locus names (defaults to \code{names} attribute of \code{freqs})}
}
\value{
List of DataFrames with genotypes for each pedigree member. See \link{sample_genotype} for the DataFrame format.
}
\description{
Sample genotypes for pedigree according to allele frequencies by allele dropping.
}
\details{
For each founder, a genotype is sampled randomly by drawing two alleles according to allele frequencies. Alleles for the rest of the pedigree are then obtained by allele dropping: \link{sample_offspring} is invoked for each non-founder.
}
\examples{
freqs <- read_allele_freqs(system.file("extdata","FBI_extended_Cauc.csv",
                           package = "simDNAmixtures"))
data(gf)

ped_sibs <- pedtools::nuclearPed(children = c("S1", "S2"))

sibs_genotypes <- sample_pedigree_genotypes(ped = ped_sibs,
freqs = freqs, loci = gf$autosomal_markers)
}
