% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat.evaluation.R
\name{cat.evaluation}
\alias{cat.evaluation}
\title{CAT Evaluation}
\usage{
cat.evaluation(results, true.scores, item.name, rmax)
}
\arguments{
\item{results}{list with results of a CAT simulation from \code{simCAT}}

\item{true.scores}{true scores}

\item{item.name}{vector with the name of all items in the bank}

\item{rmax}{item maximum exposure rate}
}
\value{
a list with two elements.

\code{evaluate} is a \code{data.frame}. Each line corresponds to a replication,
and the columns are the following variables:
\itemize{
\item \code{rmse} root mean square error between true and estimated score
\item \code{se} standard error of measurement
\item \code{correlation} correlation between true and estimated score
\item \code{bias} bias between true and estimated score
\item \code{overlap} overlap rate
\item \code{min_exp} minimum exposure rate
\item \code{max_exp} maximum exposure rate
\item \code{n_exp0} number of items not administered
\item \code{n_exp_rmax} number of items with exposure rate higher than rmax
\item \code{length_mean} average mean of test length
\item \code{length_sd} standard deviation of test length
\item \code{length_median} average median of test length
\item \code{min_length} minimum test length
\item \code{max_length} maximum test length
}
\code{conditional} is a data.frame with the same variables (except
for \code{length_sd} and \code{length_median})
conditioned to the true scores. The \code{colnames} are the thetas
in each decile, that is,
\code{quantile(true.scores, probs = seq(.1, 1, length.out = 10))}. Each
line corresponds to the mean of the investigated variables for each
decile. If there are replications, values are the replication means
for each decile.
}
\description{
Evaluate a CAT simulation
}
\examples{

\donttest{
set.seed(1)
n.items <- 50
pars <- data.frame(
 a = rlnorm(n.items),
 b = rnorm(n.items),
 c = rbeta(n.items, 5, 17),
 d = 1)

# thetas
theta <- rnorm(100)

# simulate responses
resps <- gen.resp(theta, pars[,1:3])

results <- simCAT(resps = resps,
 bank = pars[,1:3],
 start.theta = 0,
 sel.method = 'MFI',
 cat.type = 'variable',
 threshold = .3,
 stop = list(se = .3, max.items = 10))

eval <- cat.evaluation(
 results = results,
 true.scores = theta,
 item.name = paste0('I', 1:nrow(pars)),
 rmax = 1)

#### 3 replications
replications <- 3

# simulate responses
set.seed(1)
resps <- list()
for(i in 1:replications)
 resps[[i]] <- gen.resp(theta, pars[,1:3])

# CAT
results <- list()
for (rep in 1:replications)
{
 print(paste0('replication: ', rep, '/', replications))
 results[[rep]] <- simCAT(
  resps = resps[[rep]],
  bank = pars[,1:3],
  start.theta = 0,
  sel.method = 'MFI',
  cat.type = 'variable',
  threshold = .3,
  stop = list(se = .5, max.items = 10))
}

eval <- cat.evaluation(
 results = results,
 true.scores = theta,
 item.name = paste0('I', 1:nrow(pars)),
 rmax = 1)
}

}
\author{
Alexandre Jaloto
}
