% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_utility.R
\name{check_utility_calc}
\alias{check_utility_calc}
\title{Check a few things we expect to be true for the utility frame.}
\usage{
check_utility_calc(
  values,
  ...,
  orig_score = NULL,
  orig_outcome = NULL,
  constant_utilities = FALSE
)
}
\arguments{
\item{values}{model_utility result}

\item{...}{Not used, forces later argument to be specified by name.}

\item{constant_utilities}{logical, if TRUE assume utilities were constant per-row.}
}
\value{
NULL if okay, else a string describing the problem.
}
\description{
Utility to inspect a utility frame for some debugging.
}
\examples{

d <- data.frame(
  predicted_probability = c(0, 0.5, 0.5, 0.5),
  made_purchase = c(FALSE, TRUE, FALSE, FALSE),
  false_positive_value = -5,    # acting on any predicted positive costs $5
  true_positive_value = 95,     # revenue on a true positive is $100 minus action cost
  true_negative_value = 0.001,  # true negatives have no value in our application
                                # but just give ourselves a small reward for being right
  false_negative_value = -0.01  # adding a small notional tax for false negatives,
                                # don't want our competitor getting these accounts.
  )

values <- model_utility(d, 'predicted_probability', 'made_purchase')
check_utility_calc(values,
                   orig_score = d$predicted_probability,
                   orig_outcome = d$made_purchase)

}
\keyword{internal}
