% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exp_sift.R
\name{sift}
\alias{sift}
\title{Find relevant variables in a dataframe using fuzzy searches}
\usage{
sift(.df, ..., .dist = 0, .rebuild = FALSE)
}
\arguments{
\item{.df}{(Dataframe) A dataframe to search through.}

\item{...}{(Dots) Search query. Case-insensitive. See Details for more information.}

\item{.dist}{(Numeric) The maximum distance allowed for a match when searching
fuzzily. See \code{max.distance} in \code{\link[=agrep]{agrep()}}. In short: a proportion is the fraction of
the pattern length that can be flexible (e.g. \code{0.1} = 10\% of the pattern length),
whereas whole integers > 0 are the number of characters that can be flexible. \code{0} is
an exact search.}

\item{.rebuild}{(Logical) If \code{TRUE}, then force a dictionary rebuild even if it normally
would not be triggered. Rebuilds are triggered by changes to a dataframe's dimensions,
its columns (names, types, order), and/or its count of \code{NA}s in each column.}
}
\value{
Invisibly returns a dataframe. The contents of that dataframe depend on the query:
\itemize{
\item If \code{...} is empty, the full data dictionary for \code{df} is returned.
\item If the query was matched, only returns matching rows of the data dictionary.
\item If the query was not matched, return no rows of the dictionary (but all columns).
}
}
\description{
It can be hard to find the right column in a dataframe with hundreds or thousands of
columns. This function gives you interactive, flexible searching through a dataframe,
suggesting columns that are relevant to your query and showing some basic summary
stats about what they contain.
}
\details{
You have three ways to search with \code{sift()}: \emph{exact search}, \emph{fuzzy search}, or
\emph{orderless search} (also called \emph{look-around search}).
\itemize{
\item \strong{Exact search} looks for exact matches to your query. For example, searching for
\code{"weight of"} will only match \verb{weight of}.
\item \strong{Fuzzy search} gives you results that are close, but not exact, matches to your
query. This is useful because real-world labelling is not always consistent or even
correct, so using a fuzzy search for \code{"baseline"} will helpfully match \code{baseline} or
\verb{base line} or even OCR errors or typos like \code{basellne}.
\item \strong{Orderless search} matches keywords regardless of the order you give them. This
means that you can ask for \verb{cow, number} and get a match for \verb{number of cows}.
This is useful when you have an idea of what keywords should be in a variable label,
but not how those keywords are actually used or phrased. \emph{Note that this is not
a fuzzy search, so the keywords have to match exactly.}
}

The search that's performed depends on \code{...} and \code{.dist}:
\itemize{
\item \strong{Orderless search} is \emph{always} used when you pass more than one query term into \code{...}.
\item \strong{Exact search} is done when \code{.dist = 0}.
\item \strong{Fuzzy search} must be opted-into by setting the \code{.dist} argument to a value > 0. It
is ignored in orderless searching.
}
}
\examples{
\donttest{
sift(mtcars_lab)  # Builds a dictionary without searching.

sift(mtcars_lab, .)  # Show everything up to the print limit (by default, 25 matches).

sift(mtcars_lab, mileage)  # Exact search for "mileage".
sift(mtcars_lab, "above avg", .dist = 1)  # Fuzzy search (here, space -> underscore).

sift(mtcars_lab, "na", "column")  # Orderless searches are always exact.

sift(mtcars_lab, "date|time")  # Regular expression
sift(mtcars_lab, "cyl|gear", number)  # Orderless search with regular expression
}

}
\seealso{
\code{\link[=save_dictionary]{save_dictionary()}}, \code{\link[=options_sift]{options_sift()}}
}
