% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.R
\name{simulateEstimates}
\alias{simulateEstimates}
\title{Simulates capture re-capture estimates}
\usage{
simulateEstimates(nsim, N, p, htype = "None", heteroPerc = 1,
  monitorFunc = function(i) { })
}
\arguments{
\item{nsim}{number of simulations}

\item{N}{Population size}

\item{p}{A vector of capture event probabilities}

\item{htype}{The type of capture heterogeneity. Either "None" or "Normal"}

\item{heteroPerc}{The increase in odds of capture for the perc 90th percentile most likely to be captured individuals, compared to the average individual.}

\item{monitorFunc}{A function called after every iteration. Useful for monitoring simulation progress.}
}
\description{
Simulates capture re-capture estimates
}
\examples{
library(ggplot2)
# Simulate estimates from the Mt model with no population heterogeneity
ests <- simulateEstimates(15,500,c(.1,.1,.1))

# Simulate estimates from the Mth (Normal) model with no population heterogeneity.
ests2 <- simulateEstimates(20,500,c(.1,.1,.1), htype="Normal")

df <- data.frame(est = ests[[1]],type="Mt")
df <- rbind(df, data.frame(est = ests2[[1]],type="Mth (Normal)"))
qplot(x=est, color=type, data=df, geom="density") +
  geom_vline(xintercept=500,color="purple")

}
