% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-material-radio-button.R
\name{material_radio_button}
\alias{material_radio_button}
\title{Create a shinymaterial radio button}
\usage{
material_radio_button(
  input_id,
  label,
  choices,
  selected = NULL,
  color = NULL,
  with_gap = FALSE
)
}
\arguments{
\item{input_id}{String. The input identifier used to access the value.}

\item{label}{String. The radio button label.}

\item{choices}{Named vector. The option names and underyling values.}

\item{selected}{The initially selected value (if not specified then defaults to the first value).}

\item{color}{String. The color of the radio buttons. Leave empty for the default color. Visit \url{http://materializecss.com/color.html} for a list of available colors. \emph{This input requires using color hex codes, rather than the word form. E.g., "#ef5350", rather than "red lighten-1".}}

\item{with_gap}{Boolean. To create a radio button with a gap.}
}
\description{
Build a shinymaterial radio button.
}
\examples{
material_radio_button(
  input_id = "example_radio_button",
  label = "Radio Button",
  choices = c(
    "Cake" = "c",
    "Pie" = "p",
    "Brownie" = "b"
  ),
  color = "#ef5350"
)
}
\seealso{
\code{\link{update_material_radio_button}}
}
