% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-numericRange.R
\name{numericRangeInput}
\alias{numericRangeInput}
\title{Numeric Range Input}
\usage{
numericRangeInput(
  inputId,
  label,
  value,
  width = NULL,
  separator = " to ",
  min = NA,
  max = NA,
  step = NA
)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{value}{The initial value(s) for the range. A
numeric vector of length one will be duplicated to represent the minimum and
maximum of the range; a numeric vector of two or more will have its minimum
and maximum set the minimum and maximum of the range.}

\item{width}{The width of the input, e.g. \code{'400px'}, or \code{'100\%'};
see \code{\link[shiny:validateCssUnit]{validateCssUnit()}}.}

\item{separator}{String to display between the start and end input boxes.}

\item{min}{Minimum allowed value}

\item{max}{Maximum allowed value}

\item{step}{Interval to use when stepping between min and max}
}
\description{
Create an input group of numeric inputs that function as a range
input.
}
\examples{
if (interactive()) {

### examples ----

# see ?demoNumericRange
demoNumericRange()


###  basic usage ----

library( shiny )
library( shinyWidgets )


ui <- fluidPage(

  tags$br(),

  numericRangeInput(
    inputId = "my_id", label = "Numeric Range Input:",
    value = c(100, 400)
  ),
  verbatimTextOutput(outputId = "res1")

)

server <- function(input, output, session) {

  output$res1 <- renderPrint(input$my_id)

}

shinyApp(ui, server)


}
}
\seealso{
\code{\link[=updateNumericRangeInput]{updateNumericRangeInput()}}
}
