% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Accordion.R
\name{f7Accordion}
\alias{f7Accordion}
\alias{f7AccordionItem}
\alias{updateF7Accordion}
\title{Framework7 accordion container}
\usage{
f7Accordion(..., id = NULL, multiCollapse = FALSE)

f7AccordionItem(..., title = NULL, open = FALSE)

updateF7Accordion(
  id,
  selected = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{...}{Item content such as \link{f7Block} or any f7 element.}

\item{id}{Accordion instance.}

\item{multiCollapse}{Whether to open multiple items at the same time. FALSE
by default.}

\item{title}{Item title.}

\item{open}{Whether the item is open at start. FALSE by default.}

\item{selected}{Index of item to select.}

\item{session}{Shiny session object}
}
\description{
\code{f7Accordion} creates an interactive accordion container.

\code{f7AccordionItem} is to be inserted in \link{f7Accordion}.

\link{updateF7Accordion} toggles an \link{f7Accordion} on the client.
}
\examples{
# Accordion
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shinyApp(
  ui = f7Page(
    title = "Accordions",
    f7SingleLayout(
     navbar = f7Navbar("Accordions"),
     f7Accordion(
      id = "myaccordion1",
      f7AccordionItem(
       title = "Item 1",
       f7Block("Item 1 content"),
       open = TRUE
      ),
      f7AccordionItem(
       title = "Item 2",
       f7Block("Item 2 content")
      )
     ),
     f7Accordion(
      multiCollapse = TRUE,
      inputId = "myaccordion2",
      f7AccordionItem(
       title = "Item 1",
       f7Block("Item 1 content")
      ),
      f7AccordionItem(
       title = "Item 2",
       f7Block("Item 2 content")
      )
     )
    )
  ),
  server = function(input, output, session) {
   observe({
    print(
     list(
      accordion1 = input$myaccordion1,
      accordion2 = input$myaccordion2
     )
    )
   })
  }
 )
}

# Update accordion
if (interactive()) {
 library(shiny)
 library(shinyMobile)

 shinyApp(
   ui = f7Page(
     title = "Accordions",
     f7SingleLayout(
       navbar = f7Navbar("Accordions"),
       f7Button(inputId = "go", "Go"),
       f7Accordion(
         id = "myaccordion1",
         f7AccordionItem(
           title = "Item 1",
           f7Block("Item 1 content"),
           open = TRUE
         ),
         f7AccordionItem(
           title = "Item 2",
           f7Block("Item 2 content")
         )
       )
     )
   ),
   server = function(input, output, session) {

     observeEvent(input$go, {
       updateF7Accordion(id = "myaccordion1", selected = 2)
     })

     observe({
       print(
         list(
           accordion1_state = input$myaccordion1$state,
           accordion1_values = unlist(input$myaccordion1$value)
         )
       )
     })
   }
 )
}
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
