% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update-app.R
\name{updateF7Entity}
\alias{updateF7Entity}
\title{Update Framework7 entity}
\usage{
updateF7Entity(id, options, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{id}{Element id.}

\item{options}{Configuration list. Tightly depends on the entity.
See \url{https://v5.framework7.io/docs/}.}

\item{session}{Shiny session object.}
}
\description{
\link{updateF7Entity} allows to update any Framework7 instance from the server.
For each entity, the list of updatable properties may significantly vary. Please
refer to the Framework7 documentation at \url{https://v5.framework7.io/docs/}.
}
\examples{
# Update action sheet instance
if (interactive()) {
 library(shiny)
 library(shinyMobile)
 shinyApp(
   ui = f7Page(
     title = "Simple Dialog",
     f7SingleLayout(
       navbar = f7Navbar(title = "Update action sheet instance"),
       f7Button(inputId = "goButton", "Go!"),
       f7Button(inputId = "update", "Update config")
     )
   ),
   server = function(input, output, session) {
     observeEvent(input$goButton, {
       f7ActionSheet(
        grid = TRUE,
        id = "action1",
        buttons = list(
          list(
            text = "Notification",
            icon = f7Icon("info"),
            color = NULL
          ),
          list(
            text = "Dialog",
            icon = f7Icon("lightbulb_fill"),
            color = NULL
          )
        )
       )
     })

     observeEvent(input$update,{
       updateF7Entity(
       id = "action1",
        options = list(
         buttons = list(
          list(
            text = "Notification",
            icon = f7Icon("info"),
            color = NULL
          )
         )
        )
       )
     })
   }
 )
}
}
