% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rng_aggregator.R
\docType{class}
\name{rng_aggregator}
\alias{rng_aggregator}
\title{Aggregation that returns ranges of the data.}
\format{
An \code{R6::R6Class} object
}
\description{
A super class for describing aggregators that returns x, y, ylwr and yupr
values based on given x and y data.
}
\section{Super class}{
\code{\link[shinyHugePlot:aggregator]{shinyHugePlot::aggregator}} -> \code{rng_aggregator}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-rng_aggregator-new}{\code{rng_aggregator$new()}}
\item \href{#method-rng_aggregator-as_plotly_range}{\code{rng_aggregator$as_plotly_range()}}
\item \href{#method-rng_aggregator-as_range}{\code{rng_aggregator$as_range()}}
\item \href{#method-rng_aggregator-clone}{\code{rng_aggregator$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="aggregator" data-id="aggregate"><a href='../../shinyHugePlot/html/aggregator.html#method-aggregator-aggregate'><code>shinyHugePlot::aggregator$aggregate()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rng_aggregator-new"></a>}}
\if{latex}{\out{\hypertarget{method-rng_aggregator-new}{}}}
\subsection{Method \code{new()}}{
Constructor of the Aggregator.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rng_aggregator$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Arguments pass to \code{aggregator$new}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rng_aggregator-as_plotly_range"></a>}}
\if{latex}{\out{\hypertarget{method-rng_aggregator-as_plotly_range}{}}}
\subsection{Method \code{as_plotly_range()}}{
Compute a plotly trace to illustrate the range of the data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rng_aggregator$as_plotly_range(x, y, ylwr, yupr, opacity = 0.5)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x, y, ylwr, yupr}}{Outputs of the sub class of \code{rng_aggregator}.}

\item{\code{opacity}}{Numeric, optional. Opacity of the range fill.
By default, 0.5.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rng_aggregator-as_range"></a>}}
\if{latex}{\out{\hypertarget{method-rng_aggregator-as_range}{}}}
\subsection{Method \code{as_range()}}{
Compute x, y, ylwr and yupr from a plotly trace made by
\code{self$as_plotly_range}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rng_aggregator$as_range(prng)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prng}}{List of which length is 2.
Both of 2 lists are named list that contains \code{x} and \code{y},
where the one is for nominal values and the other is for range values.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rng_aggregator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-rng_aggregator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rng_aggregator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
