% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pickCheckbox.R
\name{pickCheckboxNamesAndLabels}
\alias{pickCheckboxNamesAndLabels}
\alias{pickCheckboxNames}
\alias{pickCheckboxLabels}
\title{Generate names and labels}
\usage{
pickCheckboxNames(choices)

pickCheckboxLabels(choices)
}
\arguments{
\item{choices}{link{pickCheckboxInput} choices list.}
}
\value{
Named list object defining labels for component checkbox options, or
named vector storing labels for each checkbox.
}
\description{
Two functions extracting group names and options labels from defined choices.
}
\examples{
choices_unnamed <- list(
  fruits = c("orange", "apple", "lemon"),
  vegetables = c("potato", "carrot", "broccoli")
)
pickCheckboxNames(choices_unnamed)
pickCheckboxLabels(choices_unnamed)

choices_named <- list(
  fruits = c("Orange" = "orange", "Apple" = "apple", "Lemon" = "lemon"),
  vegetables = c("Potato" = "potato", "Carrot" = "carrot", "Broccoli" = "broccoli")
)
pickCheckboxNames(choices_named)
pickCheckboxLabels(choices_named)

}
