% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update-ace-editor.R
\name{updateAceEditor}
\alias{updateAceEditor}
\title{Update Ace Editor}
\usage{
updateAceEditor(session, editorId, value, theme, readOnly, mode, fontSize,
  wordWrap, useSoftTabs, tabSize, showInvisibles, border = c("normal",
  "alert", "flash"), autoComplete = c("disabled", "enabled", "live"),
  autoCompleters = c("snippet", "text", "keyword", "static", "rlang"),
  autoCompleteList = NULL)
}
\arguments{
\item{session}{The Shiny session to whom the editor belongs}

\item{editorId}{The ID associated with this element}

\item{value}{The initial text to be contained in the editor.}

\item{theme}{The Ace \code{theme} to be used by the editor. The \code{theme}
in Ace determines the styling and coloring of the editor. Use
\code{\link{getAceThemes}} to enumerate all the themes available.}

\item{readOnly}{If set to \code{TRUE}, Ace will disable client-side editing.
If \code{FALSE} (the default), it will enable editing.}

\item{mode}{The Ace \code{mode} to be used by the editor. The \code{mode}
in Ace is often the programming or markup language that you're using and
determines things like syntax highlighting and code folding. Use the
\code{\link{getAceModes}} function to enumerate all the modes available.}

\item{fontSize}{If set, will update the font size (in px) used in the editor.
Should be an integer.}

\item{wordWrap}{If set to \code{TRUE}, Ace will enable word wrapping.
Default value is \code{FALSE}.}

\item{useSoftTabs}{Replace tabs by spaces. Default value is TRUE}

\item{tabSize}{Set tab size. Default value is 4}

\item{showInvisibles}{Show invisible characters (e.g., spaces, tabs, newline characters).
Default value is FALSE}

\item{border}{Set the \code{border} 'normal', 'alert', or 'flash'.}

\item{autoComplete}{Enable/Disable code completion. See \code{\link{aceEditor}}
for details.}

\item{autoCompleters}{List of completers to enable. If set to \code{NULL},
all completers will be disabled.}

\item{autoCompleteList}{If set to \code{NULL}, existing static completions
list will be unset. See \code{\link{aceEditor}} for details.}
}
\description{
Update the styling or mode of an aceEditor component.
}
\examples{
\dontrun{
 shinyServer(function(input, output, session) {
   observe({
     updateAceEditor(session, "myEditor", "Updated text for editor here",
       mode = "r", theme = "ambiance")
   })
 }
}

}
\author{
Jeff Allen \email{jeff@trestletech.com}
}
