% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_github_action.R
\name{set_github_action}
\alias{set_github_action}
\title{Configure GitHub Action pipeline for Docker builds}
\usage{
set_github_action(path)
}
\arguments{
\item{path}{A character string specifying the base directory where the
\code{.github/workflows/} folder will be created and the \code{docker-build.yml}
file copied. If missing, the user will be prompted to use the current directory.}
}
\value{
A logical value indicating whether the file was successfully copied
(\code{TRUE}) or not (\code{FALSE}).
}
\description{
Copies the \code{docker-build.yml} file provided by the \code{shiny2docker} package
into the \code{.github/workflows/} directory within the specified base directory.
This GitHub Action configuration is designed to build a Docker image and push the
created image to the GitHub Container Registry.
}
\examples{
# Copy the docker-build.yml file to the .github/workflows/ directory in a temporary folder
set_github_action(path = tempdir())
}
