% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database.R
\name{create_sqlite_db}
\alias{create_sqlite_db}
\title{Function to create new 'SQLite' database}
\usage{
create_sqlite_db(output_file, credentials = NULL, credentials_pass_hashed)
}
\arguments{
\item{output_file}{path to new 'SQLite' database. After creation you need to provide it to \code{login_server()}}

\item{credentials}{you can pass credentials data to create already populated tables. Provide data.frame object containing variables: timestamp, user_id, user_mail and user_pass. If there are multiple records with the same user_id, the most recent will be kept only.}

\item{credentials_pass_hashed}{specify if you put in some credentials data. Are the passwords already hashed with 'scrypt' package? Takes TRUE (if hashed) or FALSE (if not hashed and need hashing)}
}
\description{
Function to create new 'SQLite' database
}
\examples{
sqlite.path <- tempfile(fileext = "sqlite")

create_sqlite_db(sqlite.path)

database <- sqlite_get_db(sqlite.path)

# you can then pass 'sqlite.path' to you 'login_server' call
#
# login_server(db_method = "sqlite",
#              sqlite_db = sqlite.path,
#              ...)
#

print(database)
}
