% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R
\name{MultiSelect}
\alias{MultiSelect}
\alias{MultiSelect.shinyInput}
\title{MultiSelect}
\usage{
MultiSelect(...)

MultiSelect.shinyInput(
  inputId,
  items,
  selected = NULL,
  ...,
  noResults = "No results."
)
}
\arguments{
\item{...}{Component props and children. See the official Blueprint docs for details.}

\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{items}{A list of options (character vector or list containing \code{text} and \code{label} entries)}

\item{selected}{Initialy selected item}

\item{noResults}{Message when no results were found}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
Documentation: \url{https://blueprintjs.com/docs/#select/multi-select2}
}
\examples{
library(shiny)
library(shiny.blueprint)

top5Films <- list(
  list(text = "The Shawshank Redemption", label = 1994),
  list(text = "The Godfather", label = 1972),
  list(text = "The Godfather: Part II", label = 1974),
  list(text = "The Dark Knight", label = 2008),
  list(text = "12 Angry Men", label = 1957)
)

ui <- function(id) {
  ns <- NS(id)
  tagList(
    H3("Multiselect"),
    MultiSelect.shinyInput(
      inputId = ns("multiselect"),
      items = paste("Option", LETTERS),
      selected = c("Option B", "Option E"),
      tagInputProps = list(
        tagProps = list(
          intent = "danger"
        )
      )
    ),
    uiOutput(ns("multiselect_output")),
    H3("Multiselect with labels"),
    MultiSelect.shinyInput(
      inputId = ns("multiselect_lab"),
      items = top5Films,
      selected = c("12 Angry Men", "The Godfather")
    ),
    uiOutput(ns("multiselect_lab_output"))
  )
}

server <- function(id) {
  moduleServer(id, function(input, output, session) {
    output$multiselect_output <- renderText({
      paste(
        purrr::map_chr(input$multiselect[[1]], ~ .x$text),
        collapse = ", "
      )
    })

    output$multiselect_lab_output <- renderText({
      paste(
        purrr::map_chr(input$multiselect_lab[[1]], ~ .x$text),
        collapse = ", "
      )
    })
  })
}

if (interactive()) shinyApp(ui("app"), function(input, output) server("app"))
}
