% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RegionsExtend.R
\name{makeGraphDf}
\alias{makeGraphDf}
\title{Build a data.frame from a ChangeoClone and an igraph object containing a clonal lineage}
\usage{
makeGraphDf(
  curCloneGraph,
  curCloneObj,
  objSeqId = "sequence_id",
  objSeq = "sequence"
)
}
\arguments{
\item{curCloneGraph}{an igraph \code{graph} object for the lineage tree generated by 
\link[alakazam]{buildPhylipLineage}. Note that the field containing the 
nucleotide sequence in the object must be named \code{sequence}.}

\item{curCloneObj}{\link[alakazam]{ChangeoClone} object used to generate the lineage.}

\item{objSeqId}{name of the sequence identifier field in \code{curCloneObj}.}

\item{objSeq}{name of the nucleotide sequence field in \code{curCloneObj}.}
}
\value{
A \code{data.frame} with sequence and lineage information, including the
          the parent nucleotide sequence in the lineage tree(\code{parent_sequence}), 
          an internal parent identifier (\code{parent}), and additional rows for germline 
          sequence and inferred intermediate sequences.
          
          Values in the \code{sequence_id} field are renamed to numeric values,
          prefixed with the clonal grouping identifier and labeled as either \code{"Inferred"} 
          or \code{"Germline"} if they are not an observed sequence. For example, for a lineage 
          with \code{clone_id = 34} the new identifiers would be of the form: 
          \code{"34_Germline"}, \code{"34_Inferred1"}, \code{"34_1"}, \code{"34_2"}, etc.

          Note that the original sequence identifier is preserved in the \code{orig_sequence_id} field 
          and the original parent sequence identifier is retained in \code{orig_parent}.
}
\description{
\code{makeGraphDf} creates a data.frame from a \link[alakazam]{ChangeoClone} and an 
igraph \code{graph} object containing a B cell lineage tree and associated sequence data. 
The data.frame contains the original fields and additions such as each sequence's parent in the 
lineage tree, the lineage germline, and additional rows for inferred sequences.
}
\examples{
# Load and subset example data
data(ExampleDb, package = "alakazam")
data(ExampleTrees, package = "alakazam")
graph <- ExampleTrees[[17]]
db <- subset(ExampleDb, clone_id == graph$clone)
clone <- alakazam::makeChangeoClone(db)

# Extend data with lineage information
df <- makeGraphDf(graph, clone)

}
\seealso{
See \link{observedMutations} to calculate mutation frequencies using
         \code{parent_sequence} as the reference germline. See \link[alakazam]{ChangeoClone},
         \link[alakazam]{buildPhylipLineage}, and \link[igraph]{graph} for details on the 
         input objects.
}
