% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MutationDefinitions.R
\name{createMutationDefinition}
\alias{createMutationDefinition}
\title{Creates a MutationDefinition}
\usage{
createMutationDefinition(name, classes, description = "", citation = "")
}
\arguments{
\item{name}{name of the mutation definition.}

\item{classes}{named character vectors with single-letter amino acid codes as names
and amino acid classes as values, with \code{NA} assigned to set of 
characters \code{c("X", "*", "-", ".")}. Replacement (R) is be 
defined as a change in amino acid class and silent (S) as no 
change in class.}

\item{description}{description of the mutation definition and its source data.}

\item{citation}{publication source.}
}
\value{
A \code{MutationDefinition} object.
}
\description{
\code{createMutationDefinition} creates a \code{MutationDefinition}.
}
\examples{
# Define hydropathy classes
library(alakazam)
hydropathy <- list(hydrophobic=c("A", "I", "L", "M", "F", "W", "V"),
                   hydrophilic=c("R", "N", "D", "C", "Q", "E", "K"),
                   neutral=c("G", "H", "P", "S", "T", "Y"))
chars <- unlist(hydropathy, use.names=FALSE)
classes <- setNames(translateStrings(chars, hydropathy), chars)

# Create hydropathy mutation definition
md <- createMutationDefinition("Hydropathy", classes)

}
\seealso{
See \code{\link{MutationDefinition}} for the return object.
}

