% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration.R
\name{ArgmaxId}
\alias{ArgmaxId}
\alias{Argmax}
\title{Calibrated hyper-parameter(s)}
\usage{
ArgmaxId(stability = NULL, S = NULL)

Argmax(stability)
}
\arguments{
\item{stability}{output of \code{\link{VariableSelection}} or
\code{\link{GraphicalModel}}.}

\item{S}{matrix of stability scores obtained with different combinations of
parameters where rows correspond to different values of the parameter
controlling the level of sparsity in the underlying feature selection
algorithm and columns correspond to different values of the threshold in
selection proportions. If \code{S=NULL}, argument \code{stability} must be
provided.}
}
\value{
A matrix of hyper-parameters (\code{\link{Argmax}}) or indices
  (\code{\link{ArgmaxId}}). For multi-block graphical models, rows correspond
  to different blocks.
}
\description{
Extracts the calibrated hyper-parameters (or their indices for
\code{\link{ArgmaxId}}) with respect to the grids provided in \code{Lambda}
and \code{pi_list} in argument \code{stability}.
}
\examples{
\donttest{
# Data simulation
set.seed(1)
simul <- SimulateGraphical(pk = 20)

# Stability selection
stab <- GraphicalModel(xdata = simul$data)

# Extracting calibrated hyper-parameters
Argmax(stab)

# Extracting calibrated hyper-parameters IDs
ids <- ArgmaxId(stab)
ids

# Relationship between the two functions
stab$Lambda[ids[1], 1]
stab$params$pi_list[ids[2]]
}
}
\seealso{
\code{\link{VariableSelection}}, \code{\link{GraphicalModel}}
}
