% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{MatchingArguments}
\alias{MatchingArguments}
\title{Matching arguments}
\usage{
MatchingArguments(extra_args, FUN)
}
\arguments{
\item{extra_args}{vector of character strings.}

\item{FUN}{function.}
}
\value{
A vector of overlapping arguments.
}
\description{
Returns a vector of overlapping character strings between \code{extra_args}
and arguments from function \code{FUN}. If \code{FUN} is taking \code{...} as
input, this function returns \code{extra_args}.
}
\examples{
if (requireNamespace("sgPLS", quietly = TRUE)) {
  MatchingArguments(
    extra_args = list(scale = TRUE, lambda = 1),
    FUN = sgPLS::sPLS
  )
}
}
