% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sv_interaction.R
\name{sv_interaction}
\alias{sv_interaction}
\alias{sv_interaction.default}
\alias{sv_interaction.shapviz}
\alias{sv_interaction.mshapviz}
\title{SHAP Interaction Plot}
\usage{
sv_interaction(object, ...)

\method{sv_interaction}{default}(object, ...)

\method{sv_interaction}{shapviz}(
  object,
  kind = c("beeswarm", "no"),
  max_display = 7L,
  alpha = 0.3,
  bee_width = 0.3,
  bee_adjust = 0.5,
  viridis_args = getOption("shapviz.viridis_args"),
  color_bar_title = "Row feature value",
  ...
)

\method{sv_interaction}{mshapviz}(
  object,
  kind = c("beeswarm", "no"),
  max_display = 7L,
  alpha = 0.3,
  bee_width = 0.3,
  bee_adjust = 0.5,
  viridis_args = getOption("shapviz.viridis_args"),
  color_bar_title = "Row feature value",
  ...
)
}
\arguments{
\item{object}{An object of class "(m)shapviz" containing element \code{S_inter}.}

\item{...}{Arguments passed to \code{\link[ggplot2:geom_point]{ggplot2::geom_point()}}. For instance,
passing \code{size = 1} will produce smaller dots.}

\item{kind}{Set to "no" to return the matrix of average absolute SHAP
interactions (or a list of such matrices in case of object of class "mshapviz").
Due to symmetry, off-diagonals are multiplied by two. The default is "beeswarm".}

\item{max_display}{Maximum number of features (with highest importance) to plot.
Set to \code{Inf} to show all features. Has no effect if \code{kind = "no"}.}

\item{alpha}{Transparency of the beeswarm dots. Defaults to 0.3.}

\item{bee_width}{Relative width of the beeswarms.}

\item{bee_adjust}{Relative bandwidth adjustment factor used in
estimating the density of the beeswarms.}

\item{viridis_args}{List of viridis color scale arguments. The default points to the
global option \code{shapviz.viridis_args}, which corresponds to
\code{list(begin = 0.25, end = 0.85, option = "inferno")}. These values are passed to
\code{\link[ggplot2:scale_viridis]{ggplot2::scale_color_viridis_c()}}. For example, to switch to standard viridis,
either change the default with \code{options(shapviz.viridis_args = list())} or set
\code{viridis_args = list()}.}

\item{color_bar_title}{Title of color bar of the beeswarm plot. Set to \code{NULL}
to hide the color bar altogether.}
}
\value{
A "ggplot" (or "patchwork") object, or - if \code{kind = "no"} - a named
numeric matrix of average absolute SHAP interactions sorted by the average
absolute SHAP values (or a list of such matrices in case of "mshapviz" object).
}
\description{
Plots a beeswarm plot for each feature pair. Diagonals represent the main effects,
while off-diagonals show interactions (multiplied by two due to symmetry).
The colors on the beeswarm plots represent min-max scaled feature values.
Non-numeric features are transformed to numeric by calling \code{\link[=data.matrix]{data.matrix()}} first.
The features are sorted in decreasing order of usual SHAP importance.
}
\section{Methods (by class)}{
\itemize{
\item \code{sv_interaction(default)}: Default method.

\item \code{sv_interaction(shapviz)}: SHAP interaction plot for an object of class "shapviz".

\item \code{sv_interaction(mshapviz)}: SHAP interaction plot for an object of class "mshapviz".

}}
\examples{
dtrain <- xgboost::xgb.DMatrix(
  data.matrix(iris[, -1]), label = iris[, 1], nthread = 1
)
fit <- xgboost::xgb.train(data = dtrain, nrounds = 10, nthread = 1)
x <- shapviz(fit, X_pred = dtrain, X = iris, interactions = TRUE)
sv_interaction(x, kind = "no")
sv_interaction(x, max_display = 2, size = 3)
}
\seealso{
\code{\link[=sv_importance]{sv_importance()}}
}
