% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgstar.R
\name{sgstar}
\alias{sgstar}
\title{Fit Seasonal Generalized Space Time Autoregressive Model}
\usage{
sgstar(data, w, p, ps, s)
}
\arguments{
\item{data}{A dataframe that contain timeseries data with k column as space and n rows as time.}

\item{w}{a spatial weight, matrix ncol(data) * ncol(data) with diagonal = 0.}

\item{p}{an autoregressive order, value must be greater than 0.}

\item{ps}{an autoregressive order for seasonal, value must be greater than 0.}

\item{s}{an order of the seasonal period}
}
\value{
sgstar returns output with detail are shown in the following list :
\item{Coefficiens}{coefficiens parameter model for each location}
\item{Fitted.Values}{ a dataframe with fit value for each location based on model}
\item{Residual}{a dataframe that contain residual,that is response minus fitted values based on model}
\item{Performance}{a dataframe containing the following objects:}
\itemize{
   \item MSE      : Mean Squared Error (MSE) for all the data combined.
   \item RMSE     : Root Mean Squared Error (RMSE) for all the data combined.
   \item AIC      : a Version of Akaike's Information Criterion (AIC)
   \item Rsquared : R^2, the ‘fraction of variance explained by the model’.
  }
\item{p}{an autoregressive order}
\item{ps}{an autoregressive order for seasonal}
\item{s}{an order of the seasonal period}
\item{weight}{a spatial weight}
\item{data}{a dataset that used in modeling}
}
\description{
sgstar function return the parameter estimation of Seaonal Generalized Space Time Autoregressive Model by using Generalized Least Square (GLS)
}
\examples{
library(sgstar)
data("coords")
data("simulatedata")

#create weight matrix using distance inverse matrix

z<-dist(coords,method = "euclidean")
z <- as.matrix(z)

matriksd <- 1/z
matriksd[is.infinite(matriksd)] <- 0

matriksd_w <- matriksd / rowSums(as.data.frame(matriksd))

fit <- sgstar(data = simulatedata, w = matriksd_w, p = 2,ps = 1, s =4)
fit






}
\references{
Setiawan, Suhartono, and Prastuti M.(2016).S GSTAR-SUR for Seasonal Spatio Temporal Data Forecasting. Malaysian Journal Of Mathematical Sciences.10.<Corpus ID :189955959>.
}
