% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_nc.R
\name{sample_nc}
\alias{sample_nc}
\title{Nearest centroid (NC) sampling}
\usage{
sample_nc(
  mraster,
  nSamp,
  k = 1,
  iter = 500,
  algorithm = "Lloyd",
  access = NULL,
  buff_inner = NULL,
  buff_outer = NULL,
  plot = FALSE,
  details = FALSE,
  filename = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{mraster}{spatRaster. ALS metrics raster.}

\item{nSamp}{Numeric. Number of desired samples.}

\item{k}{Numeric. The number of nearest neighbours to take for each k-means center.
When \code{k = 1} (default), the output number of samples will match \code{nSamp}.
Increases to \code{k} results in a multiplicative result total number of samples \code{nSamp * k}.}

\item{iter}{Numeric. The maximum number of kmeans iterations allowed.}

\item{algorithm}{Character. \code{Lloyd} (default) or
\code{MacQueen} kmeans algorithms.}

\item{access}{sf 'LINESTRING' or 'MULTILINESTRING'. Access network.}

\item{buff_inner}{Numeric. Inner buffer boundary specifying distance
from access where plots cannot be sampled.}

\item{buff_outer}{Numeric. Outer buffer boundary specifying distance
from access where plots can be sampled.}

\item{plot}{Logical. Plot \code{mraster} with allocated samples.}

\item{details}{Logical. If \code{FALSE} (default) output is only
stratification raster. If \code{TRUE} return a list where \code{$details} is additional
stratification information and \code{$raster} is the output stratification spatRaster.}

\item{filename}{Character. Path to write stratified raster to disc.}

\item{overwrite}{Logical. Specify whether \code{filename} should be overwritten on disc.}
}
\value{
An sf object with \code{nSamp} randomly sampled points.
}
\description{
Sampling using the nearest centroid (NC) approach described in Melville & Stone (2016).
}
\note{
When \code{details = TRUE}, a list is returned where:
\enumerate{
\item \code{samples} output nearest centroid samples with \code{kcenter} attribute linking
to associated kmeans centers.
\item \code{kmeans} is a list output of the \code{\link[stats]{kmeans}} function
\item \code{centers} Un-scaled kmeans center values for each layer in \code{mraster}
with \code{kcenter} attribute to link with the same attribute in \code{samples}.
\item \code{kplot} is a \code{ggplot} scatterplot object visualizing the kmeans centers
 and associated nearest neighbor samples.
}
}
\examples{
#--- Load raster and access files ---#
r <- system.file("extdata", "mraster.tif", package = "sgsR")
mr <- terra::rast(r)

#--- perform simple random sampling ---#
sample_nc(
  mraster = mr,
  nSamp = 5,
)

}
\references{
G. Melville & C. Stone (2016) Optimising nearest neighbour information—a simple,
efficient sampling strategy for forestry plot imputation using remotely sensed data,
Australian Forestry, 79:3, 217-228, DOI: 10.1080/00049158.2016.1218265
}
\seealso{
Other sample functions: 
\code{\link{sample_ahels}()},
\code{\link{sample_balanced}()},
\code{\link{sample_clhs}()},
\code{\link{sample_existing}()},
\code{\link{sample_srs}()},
\code{\link{sample_strat}()},
\code{\link{sample_sys_strat}()},
\code{\link{sample_systematic}()}
}
\author{
Tristan R.H. Goodbody
}
\concept{sample functions}
