% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgraph_utils.R
\name{highlight_multiple_connected}
\alias{highlight_multiple_connected}
\title{Highlight edges of multiple connected nodes}
\usage{
highlight_multiple_connected(
  df_links,
  selected_nodes,
  n_max = 20,
  dark_cols = c("#ddd", "#444", "#444"),
  light_cols = c("#efefef", "#ddd", "#bbb")
)
}
\arguments{
\item{df_links}{Links data frame of a sgraph object}

\item{selected_nodes}{Nodes identifiers to be used for the selection.}

\item{n_max}{Maximum number of connected nodes, to use either
lighter or darker color sets for edges (default 20).}

\item{dark_cols}{Three hex values for colors to use with n_max.}

\item{light_cols}{Three hex values for colors to use with n_max.}
}
\value{
Links data frame of a sgraph object
}
\description{
Using a selection of nodes, highlight edges linking to nodes that are
connected to several nodes from the selection.
Differentiate multiple connected and fully connected (all selected nodes).
Use a maximum number of connected nodes to use lighter colored edges
(default 20).
}
