% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lss.R
\name{lss}
\alias{lss}
\title{Measures of location, scale and shape measures for a generalized log-gamma distribution}
\usage{
lss(mu, sigma, lambda)
}
\arguments{
\item{mu}{numeric, represents the location parameter of a generalized log-gamma distribution. Default value is 0.}

\item{sigma}{numeric, represents the scale parameter of a generalized log-gamma distribution. Default value is 1.}

\item{lambda}{numeric, represents the shape parameter of a generalized log-gamma distribution. Default value is 1.}
}
\description{
\code{lss} is used to obtain the mean, median, mode, variance, coefficient of variation, skewness and kurtosis for a generalized log-gamma distribution.
}
\examples{
lss(0,1,-1)    # Extreme value type I distribution, maximum case.
lss(0,1,1)     # Extreme value type I distribution, minimum case.
lss(0,1,0.01) # Standard normal distribution.
}
\references{
Carlos Alberto Cardozo Delgado, Semi-parametric generalized log-gamma regression models. Ph. D. thesis. Sao Paulo University.

National Institute of Standards and Technology, NIST.  Engineering Statistics Handbook.
https://www.itl.nist.gov/div898/handbook/eda/section3/eda366g.htm
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>
}
