% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deviance_residuals.R
\name{deviance_residuals}
\alias{deviance_residuals}
\title{Deviance Residuals for a Generalized Log-gamma Regression Model}
\usage{
deviance_residuals(object, ...)
}
\arguments{
\item{object}{an object of the class sglg. This object is returned from the call to glg(), sglg(), survglg() or ssurvglg().}

\item{...}{other arguments.}
}
\description{
\code{deviance_residuals} is used to generate deviance residuals for a generalized log-gamma regression model.
}
\examples{
# Example 1
n <- 300
error <- rglg(n,0,1,1)
y <- 0.5 + error
fit <- glg(y~1,data=as.data.frame(y))
deviance_residuals(fit)
# Example 2
n <- 300
error <- rglg(n,0,1,1)
x <- runif(n,-3,3)
y <- 0.5 +  2*x + error
fit <- glg(y~x,data=as.data.frame(y,x))
deviance_residuals(fit)

}
\references{
Carlos Alberto Cardozo Delgado, Semi-parametric generalized log-gamma regression models. Ph. D. thesis. Sao Paulo University.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>
}
