% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neighbors.R
\name{st_knn}
\alias{st_knn}
\title{Calculate K-Nearest Neighbors}
\usage{
st_knn(x, k = 1, symmetric = FALSE, ...)
}
\arguments{
\item{x}{an sf or sfc object.}

\item{k}{number of nearest neighbours to be returned}

\item{symmetric}{default \code{FALSE}. Whether to force output of neighbours to be symmetric.}

\item{...}{additional arguments to be passed to \code{knearneigh()}.}
}
\value{
a list of class \code{nb}
}
\description{
Identifies the \code{k} nearest neighbors for given point geometry. If polygon geometry is provided, the centroids of the polygon will be used and a warning will be emitted.
}
\details{
This function utilizes \code{\link[spdep:knearneigh]{spdep::knearneigh()}} and \code{\link[spdep:knn2nb]{spdep::knn2nb()}}.
}
\examples{
st_knn(sf::st_geometry(guerry), k = 8)
}
\seealso{
Other neighbors: 
\code{\link{st_contiguity}()},
\code{\link{st_dist_band}()}
}
\concept{neighbors}
