% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{mumps_uk_1986_1987}
\alias{mumps_uk_1986_1987}
\title{Mumps serological data from the UK in 1986 and 1987 (aggregated)}
\format{
A data frame with 3 variables:
\describe{
 \item{age}{Age group}
 \item{pos}{Number of seropositive individuals}
 \item{tot}{Total number of individuals surveyed}
}
}
\source{
Morgan-Capner P, Wright J, Miller C L, Miller E. Surveillance of
antibody to measles, mumps, and rubella by age. British Medical Journal
1988; 297 :770 \doi{doi:10.1136/bmj.297.6651.770}
}
\usage{
mumps_uk_1986_1987
}
\description{
a large survey of prevalence of antibodies to mumps and rubella viruses in
the UK. The survey, covering subjects from 1 to over 65 years of age,
provides information on the prevalence of antibody by age
}
\examples{
# Reproduce Fig 4.4 (left panel), p. 67
age <- mumps_uk_1986_1987$age
pos <- mumps_uk_1986_1987$pos
tot <- mumps_uk_1986_1987$tot
plot(age, pos / tot,
  cex = 0.008 * tot, pch = 16, xlab = "age", ylab = "seroprevalence",
  xlim = c(0, 45), ylim = c(0, 1)
)

}
\keyword{datasets}
