% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genMakefile.R
\name{writeWorkflow}
\alias{writeWorkflow}
\title{Export workflow to Makefile}
\usage{
writeWorkflow(wf, outFile)
}
\arguments{
\item{wf}{a variable workflow class}

\item{outFile}{character, typically named "Makefile"}
}
\description{
Export workflow to Makefile
}
\examples{
j1 <- newJob('id1', 'cmd out1', 'out1')
j2 <- newJob('id2', 'cmd out2', 'out2', depend = 'out1')
w <- newWorkflow("wf")
w <- addJob(w, j1)
w <- addJob(w, j2)

outFile <-  file.path(tempdir(), "Makefile")
writeWorkflow(w, outFile)
cat('Outputted Makefile file are in the temp directory:', outFile, '\n')
}
