% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_se.R
\name{filter_se}
\alias{filter_se}
\title{filter standard interface.}
\usage{
filter_se(.data, filterTerms, env = parent.frame())
}
\arguments{
\item{.data}{data.frame}

\item{filterTerms}{character vector of column expressions to filter by.}

\item{env}{environment to work in.}
}
\value{
.data filtered by columns named in filterTerms
}
\description{
Filter a data frame by the filterTerms.  Accepts arbitrary text as
filterTerms to allow forms such as "Sepal.Length >= 2 * Sepal.Width".
}
\examples{

upperBound <- 3.5

datasets::iris \%.>\%
  filter_se(., qe(Sepal.Length >= 2 * Sepal.Width,
                  Petal.Length <= upperBound))


}
\seealso{
\code{\link[dplyr]{filter}}, \code{\link[dplyr]{filter_at}}
}
