% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate_nse.R
\name{mutate_nse}
\alias{mutate_nse}
\title{mutate non-standard evaluation interface.}
\usage{
mutate_nse(.data, ...)
}
\arguments{
\item{.data}{data.frame}

\item{...}{expressions to mutate by.}
}
\value{
.data with altered columns.
}
\description{
Mutate a data frame by the mutateTerms.  Accepts arbitrary text as
mutateTerms to allow forms such as "Sepal.Length >= 2 * Sepal.Width".
Terms are vectors or lists of the form "lhs := rhs".
}
\examples{

suppressPackageStartupMessages(library("dplyr"))

resCol1 <- "Sepal_Long"
ratio <- 2
compCol1 <- "Sepal.Width"
datasets::iris \%>\%
  mutate_nse(resCol1 := "Sepal.Length" >= ratio * compCol1,
             "Petal_Short" := "Petal.Length" <= 3.5) \%>\%
  summary()


}
\seealso{
\code{\link[dplyr]{mutate}}, \code{\link[dplyr]{mutate_at}}, \code{\link[seplyr]{:=}}
}
