% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentomodel.R
\name{perform_MCS}
\alias{perform_MCS}
\title{Apply model confidence set (MCS) procedure to a selection of models}
\usage{
perform_MCS(models, loss = c("DA", "errorSq", "AD", "accuracy"), ...)
}
\arguments{
\item{models}{a named \code{list} of \code{sentomodeliter} objects. All models should be of the same family, being either
\code{"gaussian"}, \code{"binomial"} or \code{"multinomial"}, and have performance data of the same dimensions.}

\item{loss}{a single \code{character} vector, either \code{"DA"} (directional \emph{in}accuracy), \code{"errorSq"}
(squared errors), \code{"AD"} (absolute errors) or \code{"accuracy"} (\emph{in}accurate class predictions). This argument
defines on what basis the model confidence set is calculated. The first three options are available for \code{"gaussian"}
models, the last option applies only to \code{"binomial"} and \code{"multinomial"} models.}

\item{...}{other parameters that can be supplied to the \code{\link[MCS]{MCSprocedure}} function. If empty, its default
values are used.}
}
\value{
An object as returned by the \code{\link[MCS]{MCSprocedure}} function.
}
\description{
Calculates the model confidence set (see ``The Model Confidence Set''; Hansen, Lunde and Nason, 2011) as
implemented in the \pkg{MCS} package, for a set of different \code{sentomodeliter} objects.
}
\examples{
\dontrun{
data("usnews", package = "sentometrics")
data("list_lexicons", package = "sentometrics")
data("list_valence_shifters", package = "sentometrics")
data("epu", package = "sentometrics")

# construct two sentomeasures objects
corpusAll <- sento_corpus(corpusdf = usnews)
corpus <- quanteda::corpus_subset(corpusAll, date >= "1997-01-01" & date < "2014-10-01")
l <- setup_lexicons(list_lexicons[c("LM_en", "HENRY_en")], list_valence_shifters[["en"]])

ctr1 <- ctr_agg(howWithin = "tf-idf", howDocs = "proportional",
                howTime = c("equal_weight", "linear"), by = "month", lag = 3)
sentMeas1 <- sento_measures(corpus, l, ctr1)

ctr2 <- ctr_agg(howWithin = "counts", howDocs = "equal_weight",
                howTime = c("equal_weight", "linear"), by = "month", lag = 3)
sentMeas2 <- sento_measures(corpus, l, ctr2)

# prepare y and other x variables
y <- epu[epu$date >= sentMeas1$measures$date[1], ]$index
length(y) == nobs(sentMeas1) # TRUE
x <- data.frame(runif(length(y)), rnorm(length(y))) # two other (random) x variables
colnames(x) <- c("x1", "x2")

# estimate different type of regressions
ctr1 <- ctr_model(model = "gaussian", type = "AIC", do.iter = TRUE,
                  h = 0, nSample = 120, start = 50)
out1 <- sento_model(sentMeas1, y, x = x, ctr = ctr1)

ctr2 <- ctr_model(model = "gaussian", type = "AIC", do.iter = TRUE,
                  h = 0, nSample = 120, start = 50)
out2 <- sento_model(sentMeas1, y, x = NULL, ctr = ctr2)

ctr3 <- ctr_model(model = "gaussian", type = "AIC", do.iter = TRUE,
                  h = 0, nSample = 120, start = 50)
out3 <- sento_model(sentMeas2, y, x = x, ctr = ctr3)

ctr4 <- ctr_model(model = "gaussian", type = "AIC", do.iter = TRUE,
                  h = 0, nSample = 120, start = 50)
out4 <- sento_model(sentMeas2, y, x = NULL, ctr = ctr4)

mcs <- perform_MCS(models = list(m1 = out1, m2 = out2, m3 = out3, m4 = out4),
                   loss = "errorSq")}

}
\seealso{
\code{\link{sento_model}}, \code{\link[MCS]{MCSprocedure}}
}
\author{
Samuel Borms
}
