% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdal_formats_db.R
\name{gdal_formats_db}
\alias{gdal_formats_db}
\title{Create the database of GDAL supported formats}
\usage{
gdal_formats_db(gdalDrivers, json_path = NA, force = FALSE)
}
\arguments{
\item{gdalDrivers}{Function \code{gdalDrivers()} from package \code{rgdal},
which must be passed manually (this is a workaround to avoid importing
\code{rgdal} as dependency).}

\item{json_path}{(optional) The path of the output JSON file.
\emph{Warning}: to create a file which will be usable by the package,
this option must be left to NA (default location is within the
package installation). Edit this only to create the file in another
place for external use.}

\item{force}{(optional) Logical: if FALSE (default), the db is created only
if missing or not updated; if TRUE, it is created in any case..}
}
\value{
NULL (the function is called for its side effects)
}
\description{
The internal function checks if gdal_formats.json (the
database of spectral indices) already exists; if not, it
downloads source files and creates it.
Since on Windows there is an issue in reading the extension of
a GDAL driver with \code{reticulate} functions when the package \code{sen2r}
was already charged, this function can be used only from from
Linux. It is not necessary, since a gdal_formats.json file is
present in the package, but can be used to update the list in accordance
with the formats actually managed by your GDAL installation.
}
\note{
License: GPL 3.0
}
\author{
Luigi Ranghetti, phD (2019) \email{luigi@ranghetti.info}
}
