% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_lavaan_syntax.R
\name{csem2seminr}
\alias{csem2seminr}
\title{seminr csem2seminr() function}
\usage{
csem2seminr(lav_syntax)
}
\arguments{
\item{lav_syntax}{A \code{string} specifying the composite model measurement and structure using lavaan syntax}
}
\value{
A SEMinR model.
}
\description{
Converts lavaan syntax for composite models used by \code{cSEM} package to \code{SEMinR} model specifications
}
\examples{
lav_syntax <- '
  # Composite model
  Image <~ IMAG1 + IMAG2 + IMAG3 + IMAG4 + IMAG5
  Expectation <~ CUEX1 + CUEX2 + CUEX3
  Value  <~ PERV1  + PERV2
  Satisfaction <~ CUSA1 + CUSA2 + CUSA3

  # Structural model
  Satisfaction ~ Image + Expectation + Value
'

csem_model <- estimate_pls(mobi, model = csem2seminr(lav_syntax))

}
\seealso{
\code{\link{estimate_pls}}
}
