% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reliability.R
\name{rhoA}
\alias{rhoA}
\title{seminr rhoA Function}
\usage{
rhoA(seminr_model)
}
\arguments{
\item{seminr_model}{A \code{seminr_model} containing the estimated seminr model.}
}
\description{
The \code{rhoA} function calculates the rhoA reliability indices for each construct. For
formative constructs, the index is set to 1.
}
\examples{
#seminr syntax for creating measurement model
mobi_mm <- constructs(
             reflective("Image",        multi_items("IMAG", 1:5)),
             reflective("Expectation",  multi_items("CUEX", 1:3)),
             reflective("Quality",      multi_items("PERQ", 1:7)),
             reflective("Value",        multi_items("PERV", 1:2)),
             reflective("Satisfaction", multi_items("CUSA", 1:3)),
             reflective("Complaints",   single_item("CUSCO")),
             reflective("Loyalty",      multi_items("CUSL", 1:3))
           )
#seminr syntax for creating structural model
mobi_sm <- relationships(
  paths(from = "Image",        to = c("Expectation", "Satisfaction", "Loyalty")),
  paths(from = "Expectation",  to = c("Quality", "Value", "Satisfaction")),
  paths(from = "Quality",      to = c("Value", "Satisfaction")),
  paths(from = "Value",        to = c("Satisfaction")),
  paths(from = "Satisfaction", to = c("Complaints", "Loyalty")),
  paths(from = "Complaints",   to = "Loyalty")
)

mobi_pls <- estimate_pls(data = mobi,
                           measurement_model = mobi_mm,
                           structural_model = mobi_sm)

rhoA(mobi_pls)
}
\references{
Dijkstra, T. K., & Henseler, J. (2015). Consistent Partial Least Squares Path Modeling, 39(X).
}
\seealso{
\code{\link{relationships}} \code{\link{constructs}} \code{\link{paths}} \code{\link{interactions}}
         \code{\link{bootstrap_model}}
}
