% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/actions.R
\name{elem_scroll_to}
\alias{elem_scroll_to}
\title{Scroll to an element}
\usage{
elem_scroll_to(x, js = FALSE, timeout = NULL)
}
\arguments{
\item{x}{A \code{selenider_element} object.}

\item{js}{Whether to scroll to the element using JavaScript.}

\item{timeout}{How long to wait for the element to exist.}
}
\value{
\code{x}, invisibly.
}
\description{
Scrolls to an HTML element.
}
\examples{
\dontshow{if (selenider::selenider_available(online = FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
html <- "
<div style = 'height:100\%; min-height:100vh'></div>
<button onclick='checkScrolled()'></button>
<p>Scroll down to find me!</p>
"

js <- "
function checkScrolled() {
  let element = document.getElementsByTagName('p').item(0);
  let rect = element.getBoundingClientRect();
  // If paragraph is in view
  const height = window.innerHeight || document.documentElement.clientHeight;
  if (rect.bottom <= height) {
    element.innerText = 'You found me!';
  }
}
"

session <- minimal_selenider_session(html, js = js)

s("p") |>
  elem_scroll_to()

s("button") |>
  elem_click()

elem_expect(s("p"), has_text("You found me!"))
\dontshow{\}) # examplesIf}
}
\seealso{
Other actions: 
\code{\link{elem_click}()},
\code{\link{elem_hover}()},
\code{\link{elem_select}()},
\code{\link{elem_set_value}()},
\code{\link{elem_submit}()}
}
\concept{actions}
