% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditions.R
\name{is_present}
\alias{is_present}
\alias{is_in_dom}
\alias{is_absent}
\title{Does an element exist?}
\usage{
is_present(x)

is_in_dom(x)

is_absent(x)
}
\arguments{
\item{x}{A \code{selenider_element} object.}
}
\value{
A boolean value: TRUE or FALSE.
}
\description{
\code{is_present()} and \code{is_in_dom()} checks if an element is present on the page,
while \code{is_missing()} and \code{is_absent()} checks the opposite.
}
\details{
These functions do not implement a retry mechanism, and only test a condition
once. Use \code{\link[=elem_expect]{elem_expect()}} or \code{\link[=elem_wait_until]{elem_wait_until()}} to use these conditions in
tests.
}
\examples{
\dontshow{if (selenider::selenider_available(online = FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
html <- "
<p class='class1'></p>
"

session <- minimal_selenider_session(html)

is_present(s(".class1")) # TRUE

is_in_dom(s(".class2")) # FALSE

is_absent(s(".class2")) # TRUE

\dontshow{
# Clean up all connections and invalidate default chromote object
selenider_cleanup()
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other conditions: 
\code{\link{has_attr}()},
\code{\link{has_css_property}()},
\code{\link{has_length}()},
\code{\link{has_name}()},
\code{\link{has_text}()},
\code{\link{is_enabled}()},
\code{\link{is_visible}()}
}
\concept{conditions}
